(function ()
{
	// create zillaShortcodes plugin
	tinymce.create("tinymce.plugins.zillaShortcodes",
	{
		init: function ( ed, url )
		{
			ed.addCommand("zillaPopup", function ( a, params )
			{
				var popup = params.identifier;
				
				// load thickbox
				tb_show("Insert Shortcode", url + "/popup.php?popup=" + popup + "&width=" + 850);
			});
		},
		createControl: function ( btn, e )
		{
			if ( btn == "zilla_button" )
			{	
				var a = this;
				
				var btn = e.createSplitButton('zilla_button', {
                    title: "Insert Shortcode",
					image: "../wp-content/themes/alterego/functions/zilla-shortcodes/tinymce/images/icon.png",
					icons: false
                });

                btn.onRenderMenu.add(function (c, b)
				{					
					a.addWithPopup( b, "Buttons", "button" );
					a.addWithPopup( b, "Columns", "columns" );
					a.addWithPopup( b, "Spacer", "spacer" );
					a.addWithPopup( b, "Divider", "divider" );					
					a.addWithPopup( b, "Lightboxes", "lightbox" );
					a.addWithPopup( b, "Videos", "video" );
					a.addWithPopup( b, "Slider", "slider" );
					a.addWithPopup( b, "InfoBox", "infobox" );
					a.addWithPopup( b, "Tabs", "tabs" );
					a.addWithPopup( b, "Accordion", "toggle" );
					a.addWithPopup( b, "FAQ", "faq" );
					a.addWithPopup( b, "Skill Bar", "skill" );
					a.addWithPopup( b, "Quotes", "blockquote" );
					a.addWithPopup( b, "Twitter", "twitter" );
					a.addWithPopup( b, "Testamonials", "testamonials" );
					a.addWithPopup( b, "Card", "card" );
					//a.addWithoutPopup( b, "----------", "---" );
					a.addWithPopup( b, "Team 3 Cols", "team3" );
					a.addWithPopup( b, "Team 4 Cols", "team4" );
					a.addWithPopup( b, "Pricetable 3 Cols", "pricetable3" );
					a.addWithPopup( b, "Pricetable 4 Cols", "pricetable4" );
					a.addWithPopup( b, "Pricetable 5 Cols", "pricetable5" );
				});
                
                return btn;
			}
			
			return null;
		},
		addWithPopup: function ( ed, title, id ) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand("zillaPopup", false, {
						title: title,
						identifier: id
					})
				}
			})
		},
		addWithoutPopup: function ( ed, title, id ) {
			ed.add({
				title: title,
				onclick: function () {
				}
			})
		},
		addImmediate: function ( ed, title, sc) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand( "mceInsertContent", false, sc )
				}
			})
		},
		getInfo: function () {
			return {
				longname: 'Zilla Shortcodes',
				author: 'Orman Clark',
				authorurl: 'http://themeforest.net/user/ormanclark/',
				infourl: 'http://wiki.moxiecode.com/',
				version: "1.0"
			}
		}
	});
	
	// add zillaShortcodes plugin
	tinymce.PluginManager.add("zillaShortcodes", tinymce.plugins.zillaShortcodes);
})();